DROP TABLESPACE UNDOTBS1 INCLUDING CONTENTS AND DATAFILES;

CREATE UNDO TABLESPACE UNDOTBS1 DATAFILE 
  '+UNDO_TEMP_1/adrq/undo1_01' SIZE 8G AUTOEXTEND ON NEXT 5M MAXSIZE 8G,
  '+UNDO_TEMP_1/adrq/undo1_2' SIZE 8G AUTOEXTEND ON NEXT 512M MAXSIZE 8G
ONLINE
RETENTION NOGUARANTEE
BLOCKSIZE 8K
FLASHBACK ON;
DROP TABLESPACE SYSAUX INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE SYSAUX DATAFILE 
  '+DATA_1/adrq/sysaux' SIZE 3070M AUTOEXTEND ON NEXT 10M MAXSIZE 4G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL AUTOALLOCATE
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE TEMP INCLUDING CONTENTS AND DATAFILES;

CREATE TEMPORARY TABLESPACE TEMP TEMPFILE 
  '+UNDO_TEMP_1/adrq/temp_01' SIZE 12G AUTOEXTEND ON NEXT 640K MAXSIZE 12G,
  '+UNDO_TEMP_1/adrq/temp_02' SIZE 2736M AUTOEXTEND ON NEXT 640K MAXSIZE 32767M
TABLESPACE GROUP ''
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1M;
DROP TABLESPACE UNDOTBS2 INCLUDING CONTENTS AND DATAFILES;

CREATE UNDO TABLESPACE UNDOTBS2 DATAFILE 
  '+UNDO_TEMP_1/adrq/undo2_01' SIZE 1970M AUTOEXTEND ON NEXT 5M MAXSIZE 4G
ONLINE
RETENTION NOGUARANTEE
BLOCKSIZE 8K
FLASHBACK ON;
DROP TABLESPACE UNDOTBS3 INCLUDING CONTENTS AND DATAFILES;

CREATE UNDO TABLESPACE UNDOTBS3 DATAFILE 
  '+UNDO_TEMP_1/adrq/undo3_01' SIZE 4G AUTOEXTEND ON NEXT 128M MAXSIZE 4G
ONLINE
RETENTION NOGUARANTEE
BLOCKSIZE 8K
FLASHBACK ON;
DROP TABLESPACE USERS INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE USERS DATAFILE 
  '+DATA_1/adrq/users' SIZE 133M AUTOEXTEND ON NEXT 128M MAXSIZE 8G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL AUTOALLOCATE
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_DATA_01 DATAFILE 
  '+DATA_1/adrq/s_data_01_01' SIZE 4G AUTOEXTEND ON NEXT 512M MAXSIZE 4G,
  '+DATA_1/adrq/s_data_01_2' SIZE 3G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/s_index_01_01' SIZE 4608M AUTOEXTEND ON NEXT 512M MAXSIZE 8G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_data_01_01' SIZE 13416M AUTOEXTEND ON NEXT 512M MAXSIZE 16G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_index_01_01' SIZE 9456M AUTOEXTEND ON NEXT 512M MAXSIZE 16G,
  '+INDEX_1/adrq/m_index_01_02' SIZE 7696M AUTOEXTEND ON NEXT 512M MAXSIZE 16G
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_01 DATAFILE 
  '+DATA_1/adrq/l_data_01_01' SIZE 16G AUTOEXTEND ON NEXT 512M MAXSIZE 16G,
  '+DATA_1/adrq/l_data_01_02' SIZE 16G AUTOEXTEND ON NEXT 512M MAXSIZE 16G,
  '+DATA_1/adrq/l_data_01_03' SIZE 16G AUTOEXTEND ON NEXT 512M MAXSIZE 16G,
  '+DATA_1/adrq/l_data_01_04' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adrq/l_data_01_05' SIZE 11776M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/l_index_01_01' SIZE 16G AUTOEXTEND ON NEXT 512M MAXSIZE 16G,
  '+INDEX_1/adrq/l_index_01_02' SIZE 16G AUTOEXTEND ON NEXT 512M MAXSIZE 16G,
  '+INDEX_1/adrq/l_index_01_4' SIZE 4G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adrq/l_index_01_03' SIZE 29G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P01 DATAFILE 
  '+DATA_1/adrq/l_data_02_p01_01' SIZE 3776M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P02 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P02 DATAFILE 
  '+DATA_1/adrq/l_data_02_p02_01' SIZE 1984M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P03 DATAFILE 
  '+DATA_1/adrq/l_data_02_p03_01' SIZE 1920M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_02_P04 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_02_P04 DATAFILE 
  '+DATA_1/adrq/l_data_02_p04_01' SIZE 1856M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P01 DATAFILE 
  '+INDEX_1/adrq/l_index_02_p01_01' SIZE 320M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P02 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P02 DATAFILE 
  '+INDEX_1/adrq/l_index_02_p02_01' SIZE 320M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P03 DATAFILE 
  '+INDEX_1/adrq/l_index_02_p03_01' SIZE 320M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_02_P04 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_02_P04 DATAFILE 
  '+INDEX_1/adrq/l_index_02_p04_01' SIZE 384M AUTOEXTEND ON NEXT 64M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_IDH_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_IDH_DATA_01 DATAFILE 
  '+DATA_1/adrq/s_idh_data_01_01' SIZE 25472M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M,
  '+DATA_1/adrq/s_idh_data_01_02' SIZE 25216M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_IDH_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_IDH_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/s_idh_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_IDH_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_IDH_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_idh_data_01_01' SIZE 1536M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_IDH_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_IDH_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_idh_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_IDH_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_IDH_DATA_01 DATAFILE 
  '+DATA_1/adrq/l_idh_data_01_01' SIZE 3G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adrq/l_idh_data_01_02' SIZE 3G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 16M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_IDH_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_IDH_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/l_idh_index_01_01' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_1/adrq/l_idh_index_01_02' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 16M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VOA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VOA_DATA_01 DATAFILE 
  '+DATA_1/adrq/l_voa_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VOA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VOA_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/l_voa_index_01_01' SIZE 1G AUTOEXTEND ON NEXT 1G MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_VOA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_VOA_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_voa_data_01_01' SIZE 256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_VOA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_VOA_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_voa_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VOA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VOA_DATA_01 DATAFILE 
  '+DATA_1/adrq/s_voa_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VOA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VOA_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/s_voa_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRTMP_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRTMP_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_adrtmp_data_01_01' SIZE 256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRTMP_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRTMP_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_adrtmp_index_01_01' SIZE 256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ADRFILE_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ADRFILE_DATA_01 DATAFILE 
  '+DATA_1/adrq/s_adrfile_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ADRFILE_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ADRFILE_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/s_adrfile_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRFILE_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRFILE_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_adrfile_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ADRFILE_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ADRFILE_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_adrfile_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VBR_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VBR_DATA_01 DATAFILE 
  '+DATA_1/adrq/s_vbr_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_VBR_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_VBR_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/s_vbr_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VBR_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VBR_DATA_01 DATAFILE 
  '+DATA_1/adrq/l_vbr_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_VBR_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_VBR_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/l_vbr_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_DATA_03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_DATA_03 DATAFILE 
  '+DATA_2/adrq/l_data_03_01' SIZE 10G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_2/adrq/l_data_03_02' SIZE 2560M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_INDEX_03 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_INDEX_03 DATAFILE 
  '+INDEX_2/adrq/l_index_03_01' SIZE 8G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_2/adrq/l_index_03_02' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_BENS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_BENS_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_bens_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_BENS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_BENS_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_bens_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_BENS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_BENS_DATA_01 DATAFILE 
  '+DATA_1/adrq/s_bens_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_BENS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_BENS_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/s_bens_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_LOBR_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_LOBR_DATA_01 DATAFILE 
  '+DATA_3/adrq/l_lobr_data_01_01' SIZE 1G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_LOBR_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_LOBR_INDEX_01 DATAFILE 
  '+INDEX_3/adrq/l_lobr_index_01_01' SIZE 1536M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ACA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ACA_DATA_01 DATAFILE 
  '+DATA_1/adrq/s_aca_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE S_ACA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE S_ACA_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/s_aca_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ACA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ACA_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_aca_data_01_01' SIZE 384M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ACA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ACA_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_aca_index_01_01' SIZE 1664M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_ACA_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_ACA_DATA_01 DATAFILE 
  '+DATA_1/adrq/l_aca_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_ACA_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_ACA_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/l_aca_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_PSIMLOG_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_PSIMLOG_DATA_01 DATAFILE 
  '+DATA_2/adrq/l_psimlog_data_01_04' SIZE 22527M AUTOEXTEND ON NEXT 512M MAXSIZE UNLIMITED,
  '+DATA_2/adrq/l_psimlog_data_01_01' SIZE 32767M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M,
  '+DATA_2/adrq/l_psimlog_data_01_02' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_2/adrq/l_psimlog_data_01_03' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_PSIMLOG_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_PSIMLOG_INDEX_01 DATAFILE 
  '+INDEX_2/adrq/l_psimlog_index_01_01' SIZE 21760M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M,
  '+INDEX_2/adrq/l_psimlog_index_01_02' SIZE 24G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+INDEX_2/adrq/l_psimlog_index_01_03' SIZE 2G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ODM_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ODM_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_odm_data_01_01' SIZE 640M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_ODM_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_ODM_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_odm_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATS_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_pats_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATS_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_pats_index_01_01' SIZE 384M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATSRPTS_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATSRPTS_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_patsrpts_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_PATSRPTS_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_PATSRPTS_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/m_patsrpts_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_KAJEE_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_KAJEE_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_kajee_data_01_01' SIZE 256M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_QUARTZ_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_QUARTZ_DATA_01 DATAFILE 
  '+DATA_1/adrq/m_quartz_data_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_QUARTZ_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_QUARTZ_INDEX_01 DATAFILE 
  '+DATA_1/adrq/m_quartz_index_01_01' SIZE 512M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_DATA_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_DATA_02_P01 DATAFILE 
  '+DATA_2/adrq/m_data_02_p01_01' SIZE 128M AUTOEXTEND ON NEXT 32M MAXSIZE 256M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE M_INDEX_02_P01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE M_INDEX_02_P01 DATAFILE 
  '+DATA_2/adrq/m_index_02_p01_01' SIZE 128M AUTOEXTEND ON NEXT 32M MAXSIZE 256M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE ES_LOB_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE ES_LOB_01 DATAFILE 
  '+DATA_1/adrq/es_lob_01_01' SIZE 1G AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
DEFAULT 
COMPRESS FOR OLTP 
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 128K
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE GG_DATA_01_TBS INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE GG_DATA_01_TBS DATAFILE 
  '+DATA_1/adrq/ogg_data_01.dbf' SIZE 32767M AUTOEXTEND ON NEXT 512M MAXSIZE 32767M,
  '+DATA_1/adrq/ogg_data_01_02' SIZE 3G AUTOEXTEND ON NEXT 512M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 256M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_EHR_TXN_LOG_DATA_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_EHR_TXN_LOG_DATA_01 DATAFILE 
  '+DATA_1/adrq/l_ehr_txn_log_data_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
DROP TABLESPACE L_EHR_TXN_LOG_INDEX_01 INCLUDING CONTENTS AND DATAFILES;

CREATE TABLESPACE L_EHR_TXN_LOG_INDEX_01 DATAFILE 
  '+INDEX_1/adrq/l_ehr_txn_log_index_01_01' SIZE 128M AUTOEXTEND ON NEXT 128M MAXSIZE 32767M
LOGGING
ONLINE
EXTENT MANAGEMENT LOCAL UNIFORM SIZE 4M
BLOCKSIZE 8K
SEGMENT SPACE MANAGEMENT AUTO
FLASHBACK ON;
